/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.
	
	pgpWipeDelete9x.c - wipe-on-delete file system hook (Win95/98)
	

	$Id: pgpWipeDelete9x.c,v 1.6 2001/04/05 04:25:09 wjb Exp $
____________________________________________________________________________*/

#define WANTVXDWRAPS
#include <basedef.h>
#include <vmm.h>
#include <vwin32.h>
#include <ifs.h>
#include <debug.h>
#include <winerror.h>
#include <regdef.h>
#include <vxdwraps.h>

#include "PGPsdkDriver.h"
#include "pgpWipeDelete9x.h"

// Wrappers for some VXD calls (which are in the asm file)
MAKE_HEADER(ppIFSFileHookFunc,_cdecl, \
			IFSMgr_InstallFileSystemApiHook, \
			(pIFSFileHookFunc HookFunc))
MAKE_HEADER(int,_cdecl,IFSMgr_RemoveFileSystemApiHook, \
			(pIFSFileHookFunc HookFunc))
MAKE_HEADER(_QWORD,_cdecl,UniToBCSPath, \
			(unsigned char* pBCSPath, \
			PathElement* pUniPath, \
			unsigned int maxlen, \
			int charSet))
MAKE_HEADER(BOOL,_cdecl,_VWIN32_QueueUserApc, \
			(DWORD userproc,DWORD refdata,PTCB thread))
MAKE_HEADER(VOID,_cdecl,IFSMgr_Block, (unsigned long key))
MAKE_HEADER(VOID,_cdecl,IFSMgr_Wakeup, (unsigned long key))
MAKE_HEADER(VOID,_cdecl,_VolFlush, (unsigned int Volume,int Flags))

#define IFSMgr_InstallFileSystemApiHook     PREPEND(IFSMgr_InstallFileSystemApiHook)
#define IFSMgr_RemoveFileSystemApiHook      PREPEND(IFSMgr_RemoveFileSystemApiHook)
#define	UniToBCSPath					 	PREPEND(UniToBCSPath)
#define	_VWIN32_QueueUserApc				PREPEND(_VWIN32_QueueUserApc)
#define IFSMgr_Block						PREPEND(IFSMgr_Block)
#define IFSMgr_Wakeup						PREPEND(IFSMgr_Wakeup)
#define _VolFlush							PREPEND(_VolFlush)

// global data 
static ppIFSFileHookFunc ppPrevHook=0;   // the previous hooker
static VMMLIST list_handle=0;
static PTCB tc_thread=0;
static DWORD tc_callback=0;
static DWORD num_scheds=0;
static DWORD tc_flags=0;

static PVMMMUTEX listmutex=0;

typedef struct
{
	char keFileName[1024];
} KEFILERECORD,*PKEFILERECORD;

void __stdcall FillName(unsigned char *pszName, 
					   int drv, int res, int cp, pioreq pir ) 
{
    if ( (DWORD)(pir->ir_ppath) != 0 &&
         (DWORD)(pir->ir_ppath) != 0xfffffbbb ) 
	{
        int istart=0;
     
        if ( pszName != NULL ) 
		{
			if ( ((res & IFSFH_RES_CFSD)==0) && 
				drv != 0 && drv != 0xff ) 
			{
				pszName[0] = (char)('@' + drv);
				pszName[1] = (char)':';
				istart = 2;
			}

			UniToBCSPath( pszName+istart, 
				pir->ir_ppath->pp_elements, MAX_PATH, cp );
        }
    }
}

int mystrlen(char *string)
{
	int len;

	len=0;

	while(string[len]!=0)
	{
		len++;
	}

	return len;
}

char *mystrrchr(char *string,char letter)
{
	int pos;

	pos=mystrlen(string)-1;

	while(pos>=0)
	{
		if(string[pos]==letter)
			return(&(string[pos]));
		pos--;
	}

	return 0;
}

int mystrnicmp(char *string1,char *string2,int n)
{
	int index;

	for(index=0;index<n;index++)
	{
		if((string1[index]|32)!=(string2[index]|32))
		{
			return 1;
		}
	}

	return 0; // They are equal
}

/* The FileSystem Hook Function */
int __cdecl FileHook( pIFSFunc pfn, int fn, int drv, 
					 int res, int cp, pioreq pir ) 
{
	switch( fn ) 
	{
		case IFSFN_DELETE :
		{
			if((tc_callback!=0)&&(tc_flags!=0))
			{
				VMMLISTNODE listnode;
				PKEFILERECORD pkfr;
				char *szNameOnly;

				_EnterMutex (listmutex, BLOCK_THREAD_IDLE|BLOCK_SVC_INTS);

				listnode=List_Allocate(list_handle);
				pkfr=(PKEFILERECORD)listnode;

				FillName((unsigned char *)pkfr->keFileName,drv,res,cp,pir);

				szNameOnly=mystrrchr(pkfr->keFileName,'\\');

				if(szNameOnly==NULL)
					szNameOnly=pkfr->keFileName;
				else
					szNameOnly++;

				if(mystrnicmp(szNameOnly,"aaaaaaaa",8)==0)
				{
					// This is probably already been deleted, skip....
					List_Deallocate(list_handle,listnode);
					_LeaveMutex (listmutex);
					break;
				}

				if((tc_flags&WDFLAG_WIPEFILES)==0)
				{
					// There is nothing we should do here
					List_Deallocate(list_handle,listnode);
					_LeaveMutex (listmutex);
					break;
				}

				_LeaveMutex (listmutex);

				num_scheds++;

				_VWIN32_QueueUserApc(tc_callback,(DWORD)listnode,tc_thread);

				IFSMgr_Block((unsigned long)listnode);

				_EnterMutex (listmutex, BLOCK_THREAD_IDLE|BLOCK_SVC_INTS);

				List_Deallocate(list_handle,listnode);

				_LeaveMutex (listmutex);

				num_scheds--;
			}
			break;
		}
	}

	return (*(*ppPrevHook))( pfn, fn, drv, res, cp, pir );
}


//----------------------------------------------------|
//  called from OnDeviceInit when VXD is initializing

BOOL 
pgpWipeDeleteInit (void) 
{
	num_scheds=0;
	listmutex=_CreateMutex (0, MUTEX_MUST_COMPLETE);
	list_handle=List_Create(LF_ASYNC | LF_ALLOC_ERROR,sizeof(KEFILERECORD));

    ppPrevHook = IFSMgr_InstallFileSystemApiHook( FileHook );
    if ( ppPrevHook == NULL ) 
		return VXD_FAILURE;

	return VXD_SUCCESS;    	// success
}


//----------------------------------------------------|
//  called upon shutdown of VxD

BOOL 
pgpWipeDeleteCleanup (void) 
{
	IFSMgr_RemoveFileSystemApiHook( FileHook );
//	ListDestroy(list_handle);
	_DestroyMutex (listmutex);
	tc_callback=0;
	tc_thread=0;

    return VXD_SUCCESS;    // success
}   


//----------------------------------------------------|
//  called by OnDeviceIoControl to process IOCTL

VOID 
pgpWipeDeleteProcessOperation (
    PPGPWIPEDELETESTRUCT	ppwds,
	ULONG					ulStatusFlags)
{
	if (!(ulStatusFlags & kPGPUDFlag_WipeDeleteInitialized))
	{
		ppwds->ulError = kPGPUDError_DriverUninitialized;
		return;
	}

	switch (ppwds->ulOperation) 
	{
		case kPGPUDOperation_RegisterCallback :
		{
			// Get the callback
			if(num_scheds!=0)
			{
				ppwds->ulError = kPGPUDError_WipePending;
			}
			else
			{
				tc_callback=(DWORD)ppwds->usCallback;

				ppwds->ulError = kPGPUDError_NoErr;
			}
			break;
		}

		case kPGPUDOperation_RegisterThread :
		{
			// get current thread
			tc_thread=Get_Cur_Thread_Handle();

			ppwds->ulError = kPGPUDError_NoErr;
			break;
		}

		case kPGPUDOperation_RegisterFlags :
		{
			tc_flags=(DWORD)ppwds->ulFlags;

			ppwds->ulError = kPGPUDError_NoErr;
			break;
		}

		case kPGPUDOperation_MapMemory :
		{
			PKEFILERECORD pkfr;

			pkfr=(PKEFILERECORD)ppwds->keFileRecord;
			memcpy(ppwds->usFileName,pkfr->keFileName,1024);

			ppwds->ulError = kPGPUDError_NoErr;
			break;
		}

		case kPGPUDOperation_WipingDone :
		{
			IFSMgr_Wakeup((unsigned long)ppwds->keFileRecord);

			ppwds->ulError = kPGPUDError_NoErr;
			break;
		}

		case kPGPUDOperation_VolFlush :
		{
			// ulVolume contains zero based drive number
			_VolFlush(ppwds->ulVolume,0);

			ppwds->ulError = kPGPUDError_NoErr;
			break;
		}

		default :
			ppwds->ulError = kPGPUDError_UndefinedOperation;
			break;
	}
}

